// XISLOutputFSM.h: CXISLOutputFSM NX̃C^[tFCX
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_XISLOUTPUTFSM_H__94EC61BE_1DC7_4C49_AD55_14A34E77F9D2__INCLUDED_)
#define AFX_XISLOUTPUTFSM_H__94EC61BE_1DC7_4C49_AD55_14A34E77F9D2__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "XISLOutputTag.h"

class CXISLOutputFSM : public CXISLOutputTag  
{
protected:
	CString  m_strMaskID;
	int m_nParam1;
	int m_nParam2;
	BOOL m_bEndSync;
	CString m_strText;
	CPtrList *m_pTextList;

protected:
	void InitTextList();

public:
	LPCTSTR GetCharactor();
	BOOL SetCharactor(LPCTSTR lpszMaskID);

	BOOL SetText(CPtrList *pTextList,int nExpression,BOOL bEndSync);
	BOOL SetText(LPCTSTR lpszTextList,int nExpression,BOOL bEndSync);
	LPCTSTR GetText(CString &strText);
	
	BOOL SetExpression(int nExpression,int nDur);
	void GetExpression(int &nExpression,int &nDur);

	BOOL SetMotion(int nAction,int nID);
	void GetMotion(int &nAction,int &nID);

	BOOL SetAutonomous(int nAction);
	int GetAutonomous();

	BOOL SetAttribute(LPCTSTR lpszEvent,LPCTSTR lpszParam);
	void GetDrawString(CString &strText);
	LPCTSTR GetXISLString();
	BOOL RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent);

public:
	CXISLOutputFSM();
	virtual ~CXISLOutputFSM();
	CXISLOutputFSM(const CXISLOutputFSM &cpXISL); //RsR
	CXISLOutputFSM & operator=(const CXISLOutputFSM &cpXISL);

};

#endif // !defined(AFX_XISLOUTPUTFSM_H__94EC61BE_1DC7_4C49_AD55_14A34E77F9D2__INCLUDED_)
